; (*| 20:33  8/10/1989 *)
TITLE ISRAM
PAGE	60,78
;
LF	EQU	0AH
CR	EQU	0DH
;
DOSF_OUTSTR	EQU  9		; Output string
;
DOSF_DOSVER	EQU 48		; DOS version
DOSF_TERMPROC	EQU 76		; Terminate with error code
;
DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function
;
FCB_DRIVE	EQU 0		; Drive number
FCB_FNAME	EQU FCB_DRIVE+1	; File name
;
FCB1	EQU	05CH
FCB2	EQU	06CH
CMDSTR	EQU	080H
;
S0000	SEGMENT
	ASSUME	CS:S0000,DS:S0000,ES:S0000
	ORG	100H
BEGIN:	MOV	DX,OFFSET TIT_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AH,DOSF_DOSVER
	INT	DOSI_FUNC
	CMP	AL,0
	JZ	DOS1X			; quit if version 1.x
	MOV	AL,DS:BYTE PTR CMDSTR
	CMP	AL,1
	JA	CMD_OK
	MOV	DX,OFFSET CMD_MSG
	JMP	MSG_TERM
CMD_OK:
	DEC	AX
	MOV	SI,OFFSET CMDSTR+1
	PUSH	SI
	POP	DI
	STOSB
	PUSH	SI
	XOR	AX,AX
	LODSB
	MOV	CL,AL
	MOV	DI,OFFSET DIGI_AD
	REP	MOVSB
	POP	SI
	CALL	HEX_BIN
	MOV	DX,OFFSET BAD_CMD
	JC	MSG_TERM
	PUSH	AX			; segment
	XOR	BX,BX
	PUSH	BX			; offset
	CALL	TEST_MULTI_RAM
	JC	TEST_FAILED
	MOV	AH,DOSF_TERMPROC
	INT	DOSI_FUNC

DOS1X:
	MOV	DX,OFFSET VER_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	INT	DOSI_TERM

TEST_FAILED:
	MOV	DX,OFFSET NO_DIGI
MSG_TERM:
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AL,1			; Set errorlevel
	MOV	AH,DOSF_TERMPROC
	INT	DOSI_FUNC

; procedure to test for ram
; on entry DX:BX ptr to memory
; returns with CY set if in error

TEST_RAM	PROC	NEAR
	PUSH	DX
	PUSH	ES
	MOV	ES,DX
	NOP
	MOV	DL,ES:[BX]
	MOV	BYTE PTR ES:[BX],055H
	CMP	BYTE PTR ES:[BX],055H
	JNE	BAD_TEST
	MOV	BYTE PTR ES:[BX],0AAH
	CMP	BYTE PTR ES:[BX],0AAH
	JNE	BAD_TEST
	CLC
	JMP	SHORT TEST_DONE
BAD_TEST:
	STC
TEST_DONE:
	MOV	BYTE PTR ES:[BX],DL
	POP	ES
	POP	DX
	RET
TEST_RAM	ENDP

; procedure to convert hex string to binary
; on entry DS:SI ptr to string
; returns result in AX, CY set if error

HEX_BIN PROC	NEAR
	PUSH	BX
	PUSH	CX
	PUSH	SI
	XOR	AX,AX
	MOV	BX,AX
	LODSB
	CMP	AX,0
	JZ	NUL_RESULT
	MOV	CX,AX
NEXT_CHAR:
	PUSH	CX
	MOV	CX,4
	ROL	BX,CL
	POP	CX
	LODSB
	CMP	AL,'0'
	JB	NUL_RESULT
	SUB	AL,'0'
	CMP	AL,10
	JB	CHAR_OK
	CMP	AL,17
	JB	NUL_RESULT
	AND	AL,0DFH 		; convert to uppercase
	CMP	AL,22
	JA	NUL_RESULT
	SUB	AL,7
CHAR_OK:
	OR	BL,AL
	LOOP	NEXT_CHAR
	MOV	AX,BX
	CLC
	JMP	SHORT HEX_BIN_END

NUL_RESULT:
	XOR	AX,AX
	STC
HEX_BIN_END:
	POP	SI
	POP	CX
	POP	BX
	RET
HEX_BIN ENDP

TIT_MSG DB	'Ram Fitted Test Program by B. Whitnall, V1.0'
	DB	CR,LF,'$'
VER_MSG DB	'Needs DOS V2.0 or later$'
CMD_MSG DB	'No Hex Address parameter given$'
BAD_CMD DB	'Invalid Hex Value$'
NO_DIGI DB	'No ram found at '
DIGI_AD DB	'     $'

; procedure to test for ram
; on entry SEG,OFS  ptr to memory on stack
; returns with CY set if in error

RamAddress	EQU	DWORD PTR [BP+4]

TEST_MULTI_RAM	PROC	NEAR
	PUSH	BP
	MOV	BP,SP
	SUB	SP,4
	PUSH	DS
	PUSH	ES
	LDS	SI,RamAddress		; DS:SI => Address
	LODSW
	MOV	[BP-4],AX
	LODSW	
	MOV	[BP-2],AX		; save original 4 bytes
	LES	DI,RamAddress		; ES:DI => Address
	MOV	AX,0A50EH
	MOV	BX,AX
	STOSW
	NEG	AX
	STOSW
	LDS	SI,RamAddress		; DS:SI => Address
	LODSW
	CMP	AX,BX
	JNE	BAD_MULTI_TEST
	NEG	BX
	LODSW
	CMP	AX,BX
	JNE	BAD_MULTI_TEST
	CLC
	JMP	SHORT TEST_MULTI_DONE
BAD_MULTI_TEST:
	STC
TEST_MULTI_DONE:
	LES	DI,RamAddress		; ES:DI => Address
	MOV	AX,[BP-4]
	STOSW
	MOV	AX,[BP-2]
	STOSW				; recall original 4 bytes
	POP	ES
	POP	DS
	MOV	SP,BP
	POP	BP
	RET	4
TEST_MULTI_RAM	ENDP

S0000	ENDS
	END	BEGIN
